<?php
// دریافت اطلاعات چت فعال با استفاده از Prepare Statement
$stmt_chat = $conn->prepare("SELECT * FROM ".chats." WHERE (user_id_1=? OR user_id_2=?) AND status='chatting'");
$stmt_chat->execute([$user_id, $user_id]);
$row_chats = $stmt_chat->fetch();

if($row_chats){
    $reply_to_message_id = null;
    // تعیین آیدی طرف مقابل
    $user_id_select = $row_chats['user_id_1'] == $user_id ? $row_chats['user_id_2'] : $row_chats['user_id_1'];
    
    // دریافت اطلاعات امن طرف مقابل (استفاده از تابع امن شده در functions.php)
    $row = infoUser($user_id_select); 

    // تعریف دکمه‌های پایین چت
    $chat_keyboard = json_encode(['resize_keyboard' => true, 'keyboard' => [
        [['text' => $show_profile], ['text' => '🔒 چت محرمانه (خاموش/روشن)']],
        [['text' => $end_chat]]
    ]]);

    // ======================================================
    // 🔒 مدیریت دکمه چت محرمانه
    // ======================================================
    if($text == '🔒 چت محرمانه (خاموش/روشن)'){
        // تغییر وضعیت (Toggle)
        $new_status = ($row_chats['is_private'] == 1) ? 0 : 1;
        
        // آپدیت دیتابیس
        try {
            $stmt_update = $conn->prepare("UPDATE ".chats." SET is_private = ? WHERE id = ?");
            $stmt_update->execute([$new_status, $row_chats['id']]);
        } catch (PDOException $e) {
            error_log("Error updating is_private: " . $e->getMessage());
            send_reply("sendMessage",['chat_id' => $user_id, 'text' => "❌ خطا در دیتابیس."]);
            exit;
        }
        
        if($new_status == 1){
            $msg_self = "🔒 **چت محرمانه توسط شما فعال شد.**\n\nاز این پس پیام‌های این چت برای طرف مقابل قابل فوروارد کردن و ذخیره کردن نیستند.";
            $msg_partner = "🔒 **مخاطب شما چت محرمانه را فعال کرد.**\n\nدر این حالت امکان فوروارد، ذخیره پیام و اسکرین‌شات وجود ندارد.";
        } else {
            $msg_self = "🔓 **چت محرمانه توسط شما غیرفعال شد.**\n\nمحدودیت‌های فوروارد و ذخیره برداشته شدند.";
            $msg_partner = "🔓 **مخاطب شما چت محرمانه را غیرفعال کرد.**\n\nمحدودیت‌ها برداشته شدند.";
        }

        send_reply("sendMessage",['chat_id' => $user_id, 'text' => $msg_self, 'reply_to_message_id' => $message_id, 'parse_mode' => 'Markdown']);
        send_reply("sendMessage",['chat_id' => $row['user_id'], 'text' => $msg_partner, 'parse_mode' => 'Markdown']);
        exit; 
    }

    // --- بخش دکمه پایان چت ---
    if($text == $end_chat){
        send_reply("sendMessage",[
            'chat_id' => $user_id,
            'text' => "🤖 پیام سیستم 👇\n\nمطمئنی میخوای چت رو قطع کنی؟",
            'parse_mode' => 'HTML',
            'reply_to_message_id' => $message_id,
            'reply_markup' => json_encode(['inline_keyboard' => [
                [
                    ['text' => "❌ اتمام چت",'callback_data' => "endchat;{$row['uniq_id']};end"],
                    ['text' => "🗣 ادامه چت",'callback_data' => "endchat;{$row['uniq_id']};continue"]
                ]
            ]])
        ]);
        exit;
    }

    // --- هندل کردن کال‌بک پایان چت ---
    if($ex_data[0] == 'endchat'){
        if($ex_data[2] == 'end'){
            $conn->query("UPDATE ".chats." SET status='end' WHERE id='{$row_chats['id']}'");
            
            send_reply("sendMessage",[
                'chat_id' => $user_id,
                'text' => "🎌 چت شما با /user_{$row['uniq_id']} توسط شما قطع شد.\n\nبرای گزارش عدم رعایت قوانین (/ghavanin) می توانید با لمس 《 🚫 گزارش کاربر 》 در پروفایل، کاربر را گزارش کنید.",
                'reply_markup' => json_encode(['resize_keyboard' => true,'keyboard' => mainMenu(true)])
            ]);
            
            send_reply("sendMessage",[
                'chat_id' => $row['user_id'],
                'text' => "🎌 چت شما با /user_{$row_users['uniq_id']} توسط مخاطب شما قطع شد.\n\nبرای گزارش عدم رعایت قوانین (/ghavanin) می توانید با لمس 《 🚫 گزارش کاربر 》 در پروفایل، کاربر را گزارش کنید.",
                'reply_markup' => json_encode(['resize_keyboard' => true,'keyboard' => mainMenu(true)])
            ]);

            // پاکسازی نوتیفیکیشن‌ها
            $result = $conn->query("SELECT * FROM ".notif." WHERE user_id_2='{$row['user_id']}' AND reason='endchatnotif'")->fetchAll();
            foreach($result as $n_row){
                send_reply("sendMessage",['chat_id' => $n_row['user_id'],'text' => "🔔 هم اکنون چت کاربر /user_{$row['uniq_id']} به پایان رسید."]);
                $conn->query("DELETE FROM ".notif." WHERE id='{$n_row['id']}'");
            }
            $result = $conn->query("SELECT * FROM ".notif." WHERE user_id_2='$user_id' AND reason='endchatnotif'")->fetchAll();
            foreach($result as $n_row){
                send_reply("sendMessage",['chat_id' => $n_row['user_id'],'text' => "🔔 هم اکنون چت کاربر /user_{$row_users['uniq_id']} به پایان رسید.",]);
                $conn->query("DELETE FROM ".notif." WHERE id='{$n_row['id']}'");
            }
        }
        send_reply("deleteMessage",['chat_id' => $user_id,'message_id' => $message_id]);
        exit;
    }

    if($text == "/start"){
        send_reply("sendMessage",[
            'chat_id' => $user_id,
            'text' => "🤖 پیام سیستم 👇\n\n<code>    - ❗️اول باید مکالمه جاری رو قطع کنی بعدا 《استارت》 بزنی 👇</code>",
            'parse_mode' => 'HTML',
            'reply_to_message_id' => $message_id,
            'reply_markup' => $chat_keyboard
        ]);
        exit;
    }
    if(in_array($text,$btns_bot) or isset($up["callback_query"]["data"])){
        send_reply("sendMessage",[
            'chat_id' => $user_id,
            'text' => "⚠️ خطا: هم اکنون شما در حال چت با /user_{$row['uniq_id']} هستید !\n\n<code>برای استفاده از ربات ابتدا باید مکالمه رو قطع کنی 👇</code>",
            'parse_mode' => 'HTML',
            'reply_to_message_id' => $message_id,
            'reply_markup' => $chat_keyboard
        ]);
        exit;
    }

    // --- جلوگیری از ارسال لینک ---
    if($GLOBALS['entities']){
        foreach($GLOBALS['entities'] as $entity){
            if($entity['type'] == 'url' or $entity['type'] == 'text_link' or $entity['type'] == 'email' or $entity['type'] == 'mention' or $entity['type'] == 'text_mention'){
                send_reply("sendMessage",[
                    'chat_id' => $user_id,
                    'text' => "🤖 پیام سیستم 👇\n\n⚠️ خطا: امکان ارسال لینک وجود ندارد.\n\n<code>- برای ارسال لینک یا آیدی تلگرام از پیام دایرکت استفاده کنید.</code>",
                    'parse_mode' => 'HTML',
                    'reply_to_message_id' => $message_id
                ]);
                exit;
            }
        }
    }

    // --- ریپلای ---
    if(isset($up["message"]["reply_to_message"])){
        $r_message_id = $up["message"]["reply_to_message"]["message_id"];
        
        $stmt_check1 = $conn->prepare("SELECT * FROM ".chatmsgs." WHERE user_id_1 = ? AND message_id_1 = ?");
        $stmt_check1->execute([$user_id, $r_message_id]);
        $row_chatmsg = $stmt_check1->fetch();
        
        if($row_chatmsg){
            if($text == "حذف"){
                send_reply("deleteMessage",['chat_id' => $user_id,'message_id' => $r_message_id]);
                send_reply("deleteMessage",['chat_id' => $row_chatmsg['user_id_2'],'message_id' => $row_chatmsg['message_id_2']]);
                send_reply("sendMessage",['chat_id' => $user_id,'text' => "✔️ با موفقیت حذف شد.",'reply_to_message_id' => $message_id]);
                exit;
            }
            $row['user_id'] = $row_chatmsg['user_id_2'];
            $reply_to_message_id = $row_chatmsg['message_id_2'];
        }
        else{
            $stmt_check2 = $conn->prepare("SELECT * FROM ".chatmsgs." WHERE user_id_2 = ? AND message_id_2 = ?");
            $stmt_check2->execute([$user_id, $r_message_id]);
            $row_chatmsg = $stmt_check2->fetch();
            
            if($row_chatmsg){
                if($text == "حذف"){
                    send_reply("deleteMessage",['chat_id' => $user_id,'message_id' => $r_message_id]);
                    send_reply("deleteMessage",['chat_id' => $row_chatmsg['user_id_1'],'message_id' => $row_chatmsg['message_id_1']]);
                    send_reply("sendMessage",['chat_id' => $user_id,'text' => "✔️ با موفقیت حذف شد.",'reply_to_message_id' => $message_id]);
                    exit;
                }
                $row['user_id'] = $row_chatmsg['user_id_1'];
                $reply_to_message_id = $row_chatmsg['message_id_1'];
            }
        }
    }

    // --- ویرایش پیام ---
    if(isset($up["edited_message"])){
        $stmt_edit = $conn->prepare("SELECT * FROM ".chatmsgs." WHERE user_id_1 = ? AND message_id_1 = ?");
        $stmt_edit->execute([$user_id, $message_id]);
        $row_chatmsg = $stmt_edit->fetch();

        if($row_chatmsg){
            if(isset($up["edited_message"]['text'])){
                send_reply("editMessageText",[
                    'chat_id' => $row_chatmsg['user_id_2'],
                    'text' => $text . "\n\n📝 ویرایش شده در (".to_english(jdate("Y-m-d H:i")).")",
                    'message_id' => $row_chatmsg['message_id_2']
                ]);
            }
        }
        exit;
    }

    // --- ارسال پیام به مخاطب و ذخیره در کانال کش ---
    
    try {
        $stmt_insert = $conn->prepare("INSERT INTO ".chatmsgs." (user_id_1, message_id_1, user_id_2, message_id_2, created_at) VALUES (?, ?, ?, ?, ?)");
    } catch (PDOException $e) {
        error_log("Error preparing chat insert: " . $e->getMessage());
        exit; 
    }

    $protect_content = ($row_chats['is_private'] == 1) ? true : false;
    $report_markup = json_encode(['inline_keyboard' => [[['text' => "⚠️ گزارش",'callback_data' => "gib;report;{$row['uniq_id']};repchat"]]]]);

    // تنظیمات کانال کش
    $row_admin = $conn->query("SELECT * FROM ".admin)->fetch();
    $cache_channel = $row_admin['ch_cache_id']; 

    // تابع فوروارد به کانال کش
    function forwardToCache($user_id, $message_id, $cache_channel){
        if(!empty($cache_channel)){
            send_reply("forwardMessage", [
                'chat_id' => $cache_channel,
                'from_chat_id' => $user_id,
                'message_id' => $message_id
            ]);
        }
    }

    if(isset($up["message"]["text"])){
        $info_msg = send_reply("sendMessage",[
            'chat_id' => $row['user_id'],
            'text' => $text,
            'reply_to_message_id' => $reply_to_message_id,
            'protect_content' => $protect_content
        ]);
        $stmt_insert->execute([$user_id, $message_id, $row['user_id'], $info_msg['result']['message_id'], $time]);
        
        // اگر می‌خواهید متن هم در کانال کش ذخیره شود، خط زیر را فعال کنید:
        // forwardToCache($user_id, $message_id, $cache_channel);
        exit;
    }
    if(isset($up["message"]["photo"])){
        $info_msg = send_reply("sendphoto",[
            'chat_id' => $row['user_id'],
            'photo' => $up["message"]["photo"][count($up["message"]["photo"]) - 1]["file_id"],
            'caption' => $up["message"]["caption"],
            'reply_to_message_id' => $reply_to_message_id,
            'reply_markup' => $report_markup,
            'protect_content' => $protect_content
        ]);
        $stmt_insert->execute([$user_id, $message_id, $row['user_id'], $info_msg['result']['message_id'], $time]);
        
        forwardToCache($user_id, $message_id, $cache_channel);
        exit;
    }
    if(isset($up["message"]["audio"])){
        $info_msg = send_reply("sendaudio",[
            'chat_id' => $row['user_id'],
            'audio' => $up["message"]["audio"]["file_id"],
            'caption' => $up["message"]["caption"],
            'reply_to_message_id' => $reply_to_message_id,
            'reply_markup' => $report_markup,
            'protect_content' => $protect_content
        ]);
        $stmt_insert->execute([$user_id, $message_id, $row['user_id'], $info_msg['result']['message_id'], $time]);
        
        forwardToCache($user_id, $message_id, $cache_channel);
        exit;
    }
    if(isset($up["message"]["animation"])){
        $info_msg = send_reply("sendAnimation",[
            'chat_id' => $row['user_id'],
            'animation' => $up["message"]["animation"]["file_id"],
            'caption' => $up["message"]["caption"],
            'reply_to_message_id' => $reply_to_message_id,
            'reply_markup' => $report_markup,
            'protect_content' => $protect_content
        ]);
        $stmt_insert->execute([$user_id, $message_id, $row['user_id'], $info_msg['result']['message_id'], $time]);
        
        forwardToCache($user_id, $message_id, $cache_channel);
        exit;
    }
    if(isset($up["message"]["document"])){
        $info_msg = send_reply("senddocument",[
            'chat_id' => $row['user_id'],
            'document' => $up["message"]["document"]["file_id"],
            'caption' => $up["message"]["caption"],
            'reply_to_message_id' => $reply_to_message_id,
            'reply_markup' => $report_markup,
            'protect_content' => $protect_content
        ]);
        $stmt_insert->execute([$user_id, $message_id, $row['user_id'], $info_msg['result']['message_id'], $time]);
        
        forwardToCache($user_id, $message_id, $cache_channel);
        exit;
    }
    if(isset($up["message"]["voice"])){
        $info_msg = send_reply("sendVoice",[
            'chat_id' => $row['user_id'],
            'voice' => $up["message"]["voice"]["file_id"],
            'caption' => $up["message"]["caption"],
            'reply_to_message_id' => $reply_to_message_id,
            'reply_markup' => $report_markup,
            'protect_content' => $protect_content
        ]);
        $stmt_insert->execute([$user_id, $message_id, $row['user_id'], $info_msg['result']['message_id'], $time]);
        
        forwardToCache($user_id, $message_id, $cache_channel);
        exit;
    }
    if(isset($up["message"]["contact"])){
        $info_msg = send_reply("sendcontact",[
            'chat_id' => $row['user_id'],
            'phone_number' => $up["message"]["contact"]["phone_number"],
            'first_name' => $up["message"]["contact"]["first_name"],
            'caption' => $up["message"]["caption"],
            'reply_to_message_id' => $reply_to_message_id,
            'reply_markup' => $report_markup,
            'protect_content' => $protect_content
        ]);
        $stmt_insert->execute([$user_id, $message_id, $row['user_id'], $info_msg['result']['message_id'], $time]);
        exit;
    }
    if(isset($up["message"]["location"])){
        $info_msg = send_reply("sendlocation",[
            'chat_id' => $row['user_id'],
            'latitude' => $up["message"]["location"]["latitude"],
            'longitude' => $up["message"]["location"]["longitude"],
            'caption' => $up["message"]["caption"],
            'reply_to_message_id' => $reply_to_message_id,
            'reply_markup' => $report_markup,
            'protect_content' => $protect_content
        ]);
        $stmt_insert->execute([$user_id, $message_id, $row['user_id'], $info_msg['result']['message_id'], $time]);
        exit;
    }
    if(isset($up["message"]["sticker"])){
        $info_msg = send_reply("sendsticker",[
            'chat_id' => $row['user_id'],
            'sticker' => $up["message"]["sticker"]["file_id"],
            'caption' => $up["message"]["caption"],
            'reply_to_message_id' => $reply_to_message_id,
            'reply_markup' => $report_markup,
            'protect_content' => $protect_content
        ]);
        $stmt_insert->execute([$user_id, $message_id, $row['user_id'], $info_msg['result']['message_id'], $time]);
        exit;
    }
    // Video support
    if(isset($up["message"]["video"])){
         $info_msg = send_reply("sendVideo",[
            'chat_id' => $row['user_id'],
            'video' => $up["message"]["video"]["file_id"],
            'caption' => $up["message"]["caption"],
            'reply_to_message_id' => $reply_to_message_id,
            'reply_markup' => $report_markup,
            'protect_content' => $protect_content
        ]);
        $stmt_insert->execute([$user_id, $message_id, $row['user_id'], $info_msg['result']['message_id'], $time]);
        
        forwardToCache($user_id, $message_id, $cache_channel);
        exit;
    }
    // Video Note Support
    if(isset($up["message"]["video_note"])){
         $info_msg = send_reply("sendVideoNote",[
            'chat_id' => $row['user_id'],
            'video_note' => $up["message"]["video_note"]["file_id"],
            'reply_to_message_id' => $reply_to_message_id,
            'reply_markup' => $report_markup,
            'protect_content' => $protect_content
        ]);
        $stmt_insert->execute([$user_id, $message_id, $row['user_id'], $info_msg['result']['message_id'], $time]);
        
        forwardToCache($user_id, $message_id, $cache_channel);
        exit;
    }
    exit;
}
?>