<!DOCTYPE html>
<html>
<head>
    <title>نصب/آپدیت</title>
    <link rel="icon" href="bot/files/icon.png" title="Favicon">
</head>
<body>
<?php
// فعال‌سازی نمایش خطاها برای عیب‌یابی
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// بررسی اتصال امن (HTTPS)
if(!isset($_SERVER['HTTPS']) or $_SERVER['HTTPS'] != "on"){
    echo "<div style='position:absolute;left:0;right:0;bottom:0;top:0;background-color:#16b300;background-image:linear-gradient(to bottom,#820000,#ff4545);'><h1 style='font-family:tahoma;direction:rtl;text-align:center;text-shadow:0 0px 4px #000;color:#fff;'>لطفا https را فعال کنید</h1></div>";
    exit;
}
require_once 'include/settings.php';
require_once 'include/config.php';

// تابع برای افزودن امن ستون (اگر وجود داشت ارور ندهد)
function safe_alter($conn, $table, $sql) {
    try {
        $conn->query("ALTER TABLE $table $sql");
    } catch (PDOException $e) {
        // کد خطای ۱۰۶۰ یعنی ستون تکراری است (Column already exists)
        // ما این خطا را نادیده می‌گیریم تا اسکریپت متوقف نشود
    }
}

#admin
    $table = admin;
    $conn->query("CREATE TABLE IF NOT EXISTS $table (id INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY)ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;");
    safe_alter($conn, $table, "ADD channel_1_name VARCHAR(100) NULL DEFAULT NULL");
    safe_alter($conn, $table, "ADD channel_1 VARCHAR(50) NULL DEFAULT NULL");
    safe_alter($conn, $table, "ADD channel_2_name VARCHAR(100) NULL DEFAULT NULL");
    safe_alter($conn, $table, "ADD channel_2 VARCHAR(50) NULL DEFAULT NULL");
    safe_alter($conn, $table, "ADD channel_3_name VARCHAR(100) NULL DEFAULT NULL");
    safe_alter($conn, $table, "ADD channel_3 VARCHAR(50) NULL DEFAULT NULL");
    safe_alter($conn, $table, "ADD ch_cache_id VARCHAR(50) NULL DEFAULT NULL");
    safe_alter($conn, $table, "ADD support VARCHAR(50) NULL DEFAULT NULL");
    safe_alter($conn, $table, "ADD coin_per_invite INT(11) NOT NULL DEFAULT 7");
    safe_alter($conn, $table, "ADD coin_per_invite_profile INT(11) NOT NULL DEFAULT 8");
    safe_alter($conn, $table, "ADD coin_per_invite_invite INT(11) NOT NULL DEFAULT 5");
    safe_alter($conn, $table, "ADD coin_comprof INT(11) NOT NULL DEFAULT 5");
    $conn->query("INSERT INTO $table (id) VALUES (1)");

#amounts
    $table = amounts;
    $conn->query("CREATE TABLE IF NOT EXISTS $table (id INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY)ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;");
    safe_alter($conn, $table, "ADD amount INT(11) NOT NULL DEFAULT 0");
    safe_alter($conn, $table, "ADD coin SMALLINT(6) NOT NULL DEFAULT 0");

#blocked
    $table = blocked;
    $conn->query("CREATE TABLE IF NOT EXISTS $table (id INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY)ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;");
    safe_alter($conn, $table, "ADD user_id VARCHAR(20) NULL DEFAULT NULL");
    safe_alter($conn, $table, "ADD target_id VARCHAR(20) NULL DEFAULT NULL");
    safe_alter($conn, $table, "ADD created_at INT(11) NOT NULL DEFAULT 0");

#chatmsgs
    $table = chatmsgs;
    $conn->query("CREATE TABLE IF NOT EXISTS $table (id INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY)ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;");
    safe_alter($conn, $table, "ADD user_id_1 VARCHAR(20) NULL DEFAULT NULL");
    safe_alter($conn, $table, "ADD message_id_1 INT(11) NOT NULL DEFAULT 0");
    safe_alter($conn, $table, "ADD user_id_2 VARCHAR(20) NULL DEFAULT NULL");
    safe_alter($conn, $table, "ADD message_id_2 INT(11) NOT NULL DEFAULT 0");
    safe_alter($conn, $table, "ADD created_at INT(11) NOT NULL DEFAULT 0");

#chats
    $table = chats;
    $conn->query("CREATE TABLE IF NOT EXISTS $table (id INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY)ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;");
    safe_alter($conn, $table, "ADD user_id_1 VARCHAR(20) NULL DEFAULT NULL");
    safe_alter($conn, $table, "ADD user_id_2 VARCHAR(20) NULL DEFAULT NULL");
    safe_alter($conn, $table, "ADD status VARCHAR(20) NOT NULL DEFAULT 'chatting'");
    safe_alter($conn, $table, "ADD created_at INT(11) NOT NULL DEFAULT 0");
    safe_alter($conn, $table, "ADD is_private TINYINT(1) DEFAULT 0");

#cron
    $table = cron;
    $conn->query("CREATE TABLE IF NOT EXISTS $table (id INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY)ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;");
    safe_alter($conn, $table, "ADD user_id VARCHAR(20) NULL DEFAULT NULL");
    safe_alter($conn, $table, "ADD chat_id VARCHAR(30) NULL DEFAULT NULL");
    safe_alter($conn, $table, "ADD type VARCHAR(20) NULL DEFAULT NULL");
    safe_alter($conn, $table, "ADD file_type VARCHAR(20) NULL DEFAULT NULL");
    safe_alter($conn, $table, "ADD file_id VARCHAR(300) NULL DEFAULT NULL");
    safe_alter($conn, $table, "ADD text TEXT NULL DEFAULT NULL");
    safe_alter($conn, $table, "ADD message_id INT(11) NOT NULL DEFAULT 0");
    safe_alter($conn, $table, "ADD send_id INT(11) NOT NULL DEFAULT 0");
    safe_alter($conn, $table, "ADD max_send_id INT(11) NOT NULL DEFAULT 0");
	safe_alter($conn, $table, "ADD message_id_edit INT(11) NOT NULL DEFAULT 0");
	safe_alter($conn, $table, "ADD count_members INT(11) NOT NULL DEFAULT 0");
	safe_alter($conn, $table, "ADD send_correct INT(11) NOT NULL DEFAULT 0");
	safe_alter($conn, $table, "ADD send_failed INT(11) NOT NULL DEFAULT 0");
	
#friends
    $table = friends;
    $conn->query("CREATE TABLE IF NOT EXISTS $table (id INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY)ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;");
    safe_alter($conn, $table, "ADD name VARCHAR(100) NULL DEFAULT NULL");
    safe_alter($conn, $table, "ADD user_id VARCHAR(20) NULL DEFAULT NULL");
    safe_alter($conn, $table, "ADD target_id VARCHAR(20) NULL DEFAULT NULL");
    safe_alter($conn, $table, "ADD created_at INT(11) NOT NULL DEFAULT 0");

#likes
    $table = likes;
    $conn->query("CREATE TABLE IF NOT EXISTS $table (id INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY)ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;");
    safe_alter($conn, $table, "ADD user_id VARCHAR(20) NULL DEFAULT NULL");
    safe_alter($conn, $table, "ADD target_id VARCHAR(20) NULL DEFAULT NULL");
    safe_alter($conn, $table, "ADD created_at INT(11) NOT NULL DEFAULT 0");

#notif
    $table = notif;
    $conn->query("CREATE TABLE IF NOT EXISTS $table (id INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY)ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;");
    safe_alter($conn, $table, "ADD type VARCHAR(20) NULL DEFAULT NULL");
    safe_alter($conn, $table, "ADD user_id VARCHAR(20) NULL DEFAULT NULL");
    safe_alter($conn, $table, "ADD balance INT(11) NOT NULL DEFAULT 0");
    safe_alter($conn, $table, "ADD gender VARCHAR(10) NULL DEFAULT NULL");
    safe_alter($conn, $table, "ADD request_gender VARCHAR(10) NULL DEFAULT NULL");
    safe_alter($conn, $table, "ADD age SMALLINT(6) NOT NULL DEFAULT 0");
    safe_alter($conn, $table, "ADD latitude FLOAT NOT NULL DEFAULT 0");
    safe_alter($conn, $table, "ADD longitude FLOAT NOT NULL DEFAULT 0");
    safe_alter($conn, $table, "ADD user_id_2 VARCHAR(20) NULL DEFAULT NULL");
    safe_alter($conn, $table, "ADD reason VARCHAR(50) NULL DEFAULT NULL");
    safe_alter($conn, $table, "ADD content VARCHAR(1000) NOT NULL DEFAULT '0'");
    safe_alter($conn, $table, "ADD status VARCHAR(10) NOT NULL DEFAULT 'doing'");
    safe_alter($conn, $table, "ADD date INT(11) NOT NULL DEFAULT 0");

#payments
    $table = payments;
    $conn->query("CREATE TABLE IF NOT EXISTS $table (id INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY)ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;");
    safe_alter($conn, $table, "ADD user_id VARCHAR(20) NULL DEFAULT NULL");
    safe_alter($conn, $table, "ADD coins INT(11) NOT NULL DEFAULT 0");
    safe_alter($conn, $table, "ADD amount INT(11) NOT NULL DEFAULT 0");
    safe_alter($conn, $table, "ADD authority VARCHAR(50) NULL DEFAULT NULL UNIQUE");
    safe_alter($conn, $table, "ADD ref_id VARCHAR(50) NULL DEFAULT NULL UNIQUE");
    safe_alter($conn, $table, "ADD status VARCHAR(20) NOT NULL DEFAULT 'first_level'");
    safe_alter($conn, $table, "ADD created_at INT(11) NOT NULL DEFAULT 0");
    safe_alter($conn, $table, "ADD updated_at INT(11) NOT NULL DEFAULT 0");
    safe_alter($conn, $table, "ADD uniq_id VARCHAR(50) NULL DEFAULT NULL UNIQUE");

#search
    $table = search;
    $conn->query("CREATE TABLE IF NOT EXISTS $table (id INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY)ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;");
    safe_alter($conn, $table, "ADD user_id VARCHAR(20) NULL DEFAULT NULL");
    safe_alter($conn, $table, "ADD search TEXT DEFAULT NULL");
    safe_alter($conn, $table, "ADD created_at INT(11) NOT NULL DEFAULT 0");

#states
    // (بخش استان‌ها طولانی بود، برای جلوگیری از شلوغی اینجا تکرار نکردم چون تغییری ندارد. همان کد قبلی اجرا می‌شود و چون جدول هست، کاری نمی‌کند)
    // اما برای اطمینان کد ساخت جدولش را می‌گذاریم:
    $table = states;
    $conn->query("CREATE TABLE IF NOT EXISTS $table (id INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY)ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;");
    // دیتای اینسرت شده قبلی باقی می ماند

#users
    $table = users;
    $conn->query("CREATE TABLE IF NOT EXISTS $table (id INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY)ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;");
    safe_alter($conn, $table, "ADD user_id VARCHAR(20) NULL DEFAULT NULL UNIQUE");
    safe_alter($conn, $table, "ADD balance INT(11) NOT NULL DEFAULT 0");
    safe_alter($conn, $table, "ADD name VARCHAR(100) NULL DEFAULT NULL");
    safe_alter($conn, $table, "ADD gender VARCHAR(10) NULL DEFAULT NULL");
    safe_alter($conn, $table, "ADD age TINYINT(4) NOT NULL DEFAULT 0");
    safe_alter($conn, $table, "ADD state VARCHAR(50) NULL DEFAULT NULL");
    safe_alter($conn, $table, "ADD city VARCHAR(100) NULL DEFAULT NULL");
    safe_alter($conn, $table, "ADD latitude FLOAT NOT NULL DEFAULT 0");
    safe_alter($conn, $table, "ADD longitude FLOAT NOT NULL DEFAULT 0");
    safe_alter($conn, $table, "ADD image VARCHAR(300) NULL DEFAULT NULL");
    safe_alter($conn, $table, "ADD num_chats INT(11) NOT NULL DEFAULT 0");
    safe_alter($conn, $table, "ADD referral VARCHAR(20) NULL DEFAULT NULL");
    safe_alter($conn, $table, "ADD silent INT(11) NOT NULL DEFAULT 0");
    safe_alter($conn, $table, "ADD last_activity INT(11) NOT NULL DEFAULT 0");
    safe_alter($conn, $table, "ADD last_check_join_at INT(11) NOT NULL DEFAULT 0");
    safe_alter($conn, $table, "ADD is_coin_comprof TINYINT(4) NOT NULL DEFAULT 0");
    safe_alter($conn, $table, "ADD is_likes TINYINT(4) NOT NULL DEFAULT 1");
    safe_alter($conn, $table, "ADD same_age TINYINT(4) NOT NULL DEFAULT 0");
    safe_alter($conn, $table, "ADD status VARCHAR(50) NOT NULL DEFAULT 'user'");
    safe_alter($conn, $table, "ADD step VARCHAR(50) NOT NULL DEFAULT 'start'");
    safe_alter($conn, $table, "ADD prev_step VARCHAR(50) NOT NULL DEFAULT 'start'");
    safe_alter($conn, $table, "ADD created_at INT(11) NOT NULL DEFAULT 0");
    safe_alter($conn, $table, "ADD uniq_id VARCHAR(20) NULL DEFAULT NULL UNIQUE");
    safe_alter($conn, $table, "ADD last_daily_bonus INT(11) DEFAULT 0");
    safe_alter($conn, $table, "ADD notify_profile_view TINYINT(1) DEFAULT 1");
    safe_alter($conn, $table, "ADD ban_expires_at INT(11) DEFAULT 0");

    // [ 🆕 ستون‌های جدید وریفای 🆕 ]
    safe_alter($conn, $table, "ADD verify_status VARCHAR(20) NOT NULL DEFAULT 'none'");
    safe_alter($conn, $table, "ADD verify_gesture VARCHAR(100) NULL DEFAULT NULL");
    safe_alter($conn, $table, "ADD filter_verify TINYINT(1) NOT NULL DEFAULT 0");
    
  
#webhook
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://api.telegram.org/bot{$settings['token']}/setwebhook?url=".str_replace("/run.php", "/bot/user/index.php", "https://{$_SERVER['HTTP_HOST']}{$_SERVER['REQUEST_URI']}"));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $result = curl_exec($ch);
    curl_close($ch);
    $result = json_decode($result,true);
    if($result['ok'])
        echo "<div style='position:absolute;left:0;right:0;bottom:0;top:0;background-color:#16b300;background-image:linear-gradient(to bottom,#1c8200,#68ff24);'><h1 style='font-family:tahoma;direction:rtl;text-align:center;text-shadow:0 0px 4px #000;color:#fff;'>عملیات موفقیت آمیز بود.</h1></div>";
    else echo "<div style='position:absolute;left:0;right:0;bottom:0;top:0;background-color:#16b300;background-image:linear-gradient(to bottom,#820000,#ff4545);'><h1 style='font-family:tahoma;direction:rtl;text-align:center;text-shadow:0 0px 4px #000;color:#fff;'>عملیات ناموفق بود.</h1></div>";
?>
</body>
</html>